VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "mscomctl.ocx"
Begin VB.Form DC_PLPicker 
   Caption         =   "Form2"
   ClientHeight    =   5085
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5775
   LinkTopic       =   "Form2"
   ScaleHeight     =   5085
   ScaleWidth      =   5775
   StartUpPosition =   3  'Windows Default
   Begin Project1.A_calocx cal_validFrom 
      Height          =   390
      Left            =   1770
      TabIndex        =   13
      Top             =   2205
      Width           =   1740
      _ExtentX        =   3069
      _ExtentY        =   688
   End
   Begin VB.CommandButton OKButton 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   4515
      TabIndex        =   5
      Top             =   4530
      Width           =   1215
   End
   Begin VB.CommandButton CancelButton 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3090
      TabIndex        =   4
      Top             =   4530
      Width           =   1215
   End
   Begin VB.TextBox txt_DropOff 
      Height          =   330
      Left            =   2550
      TabIndex        =   1
      Top             =   3045
      Width           =   855
   End
   Begin VB.TextBox txt_firstRow 
      Height          =   330
      Left            =   1830
      Locked          =   -1  'True
      TabIndex        =   0
      Top             =   825
      Width           =   600
   End
   Begin Project1.ArmCombobox cbo_DC_CARRIER_Code 
      Height          =   345
      Left            =   2550
      TabIndex        =   2
      Top             =   1305
      Width           =   3105
      _ExtentX        =   5477
      _ExtentY        =   609
   End
   Begin MSComctlLib.ListView lv_items 
      Height          =   1215
      Left            =   2535
      TabIndex        =   3
      Top             =   0
      Width           =   3120
      _ExtentX        =   5503
      _ExtentY        =   2143
      View            =   3
      LabelWrap       =   0   'False
      HideSelection   =   0   'False
      HideColumnHeaders=   -1  'True
      GridLines       =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   1
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "Sheet name"
         Object.Width           =   4940
      EndProperty
   End
   Begin Project1.ArmCombobox cbo_UOM_Code 
      Height          =   345
      Left            =   2550
      TabIndex        =   6
      Top             =   2685
      Width           =   3105
      _ExtentX        =   5477
      _ExtentY        =   609
   End
   Begin Project1.A_calocx cal_validTo 
      Height          =   390
      Left            =   3945
      TabIndex        =   14
      Top             =   2205
      Width           =   1740
      _ExtentX        =   3069
      _ExtentY        =   688
   End
   Begin Project1.ArmCombobox cbo_currency 
      Height          =   345
      Left            =   2550
      TabIndex        =   16
      Top             =   3840
      Width           =   3105
      _ExtentX        =   5477
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_fullTruckCalc 
      Height          =   345
      Left            =   2550
      TabIndex        =   20
      Top             =   3405
      Width           =   3105
      _ExtentX        =   5477
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_TT_Code 
      Height          =   345
      Left            =   2550
      TabIndex        =   21
      Top             =   1710
      Width           =   3105
      _ExtentX        =   5477
      _ExtentY        =   609
   End
   Begin VB.Label lbl_labels 
      Caption         =   "Full truck calculated"
      Height          =   300
      Index           =   9
      Left            =   60
      TabIndex        =   19
      Top             =   3435
      Width           =   2100
   End
   Begin VB.Label lbl_labels 
      Caption         =   "Price list valid for:"
      Height          =   300
      Index           =   8
      Left            =   60
      TabIndex        =   18
      Top             =   1725
      Width           =   2100
   End
   Begin VB.Label lbl_labels 
      Caption         =   "Currency"
      Height          =   300
      Index           =   3
      Left            =   60
      TabIndex        =   17
      Top             =   3855
      Width           =   2100
   End
   Begin VB.Label lbl_labels 
      Alignment       =   2  'Center
      Caption         =   "-"
      Height          =   300
      Index           =   7
      Left            =   3525
      TabIndex        =   15
      Top             =   1755
      Width           =   285
   End
   Begin VB.Label lbl_labels 
      Caption         =   "Validity"
      Height          =   300
      Index           =   6
      Left            =   60
      TabIndex        =   12
      Top             =   2235
      Width           =   930
   End
   Begin VB.Label lbl_labels 
      Caption         =   "Excell sheet"
      Height          =   300
      Index           =   0
      Left            =   60
      TabIndex        =   11
      Top             =   30
      Width           =   2100
   End
   Begin VB.Label lbl_labels 
      Caption         =   "Drop off cost"
      Height          =   300
      Index           =   1
      Left            =   60
      TabIndex        =   10
      Top             =   3075
      Width           =   2100
   End
   Begin VB.Label lbl_labels 
      Caption         =   "Distribution center / Carrier"
      Height          =   300
      Index           =   2
      Left            =   60
      TabIndex        =   9
      Top             =   1350
      Width           =   2100
   End
   Begin VB.Label lbl_labels 
      Caption         =   "First valid row"
      Height          =   300
      Index           =   5
      Left            =   60
      TabIndex        =   8
      Top             =   855
      Width           =   1530
   End
   Begin VB.Label lbl_labels 
      Caption         =   "Units of measure"
      Height          =   300
      Index           =   4
      Left            =   60
      TabIndex        =   7
      Top             =   2700
      Width           =   2100
   End
End
Attribute VB_Name = "DC_PLPicker"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""

Public Result As Boolean
Public DC_Code As String
Public CARRIER_code As String
Public DC_CARRIER_Code As Long
Public UOM_Code As String
Public DropOffCost As Double
Public ValidityStart As Date
Public ValidityEnd As Date
Public CURR_Code As String
Public FullTruckCalculation As String
Public TT_Code As String
Public TenderCarrier As Long

Public FirstRow As Long
Public XLSSheetName As String

Private ms_Language_Code As String

Private mo_Db As ARMSYSCOMLib.ArmDb

Public Property Set Db(ByRef ao_Db As ArmDb)
    Set mo_Db = ao_Db
End Property

Public Sub Load_A_COM()
    Result = False
    DC_Code = ""
    CARRIER_code = ""
    DC_CARRIER_Code = 0
    UOM_Code = ""
    DropOffCost = 0
    ValidityStart = 0
    ValidityEnd = 0
    CURR_Code = ""
    TT_Code = ""
    FullTruckCalculation = ""
    ms_Language_Code = "E"
    FirstRow = 0
    XLSSheetName = ""
    
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMPICKER"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
          lo_Control.Language = ms_Language_Code
'          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMGRID"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "A_CALOCX"
          lo_Control.Language = ms_Language_Code
          Call lo_Control.reinit_cal
        Case "TOOLBR"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        End Select
    Next

    
    txt_firstRow.Enabled = False
    txt_firstRow.Text = ""
    
    cbo_DC_CARRIER_Code.FirstBlankItem = False
    cbo_DC_CARRIER_Code.Request = "EXEC DC_Carrier_link_cbo " & TenderCarrier & "," & SqlStr(ms_Language_Code, 1)
    cbo_DC_CARRIER_Code.Load
    
    cbo_UOM_Code.FirstBlankItem = False
    cbo_UOM_Code.Request = "EXEC DC_UOM_cbo2"
    cbo_UOM_Code.Load

    cbo_currency.FirstBlankItem = False
    cbo_currency.Request = "EXEC currencies_cbo " & SqlStr(ms_Language_Code, 1)
    cbo_currency.Load
    
    cbo_TT_Code.FirstBlankItem = False
    Call cbo_TT_Code.AddItem(Array("T", "Container shippment"))
    Call cbo_TT_Code.AddItem(Array("C", "Customer shippment"))
    Call cbo_TT_Code.AddItem(Array("I", "Intercompany shippment"))
    Call cbo_TT_Code.AddItem(Array("R", "Reciepts"))
    
    cbo_fullTruckCalc.FirstBlankItem = False
    Call cbo_fullTruckCalc.AddItem(Array("Y", "Yes"))
    Call cbo_fullTruckCalc.AddItem(Array("N", "No"))

    
    lv_items.ListItems.Clear
End Sub

Public Property Let Title(ByVal as_caption As String)
    Me.Caption = as_caption
End Property

Public Function AddItem(ByVal as_Key As String, ByVal as_desc As String) As ListItem
    Set AddItem = lv_items.ListItems.Add(, as_Key, as_desc)
End Function

Private Sub CancelButton_Click()
    Result = False
    
    Unload Me
End Sub


'Private Sub lv_items_DblClick()
'    If Item_Check Then
'        Call Item_Save
'        Unload Me
'    End If
'End Sub

Public Sub lv_items_ItemClick(ByVal Item As MSComctlLib.ListItem)
On Error GoTo errorHandler
    
    Dim lsa_data() As String
    lsa_data = Split(Item.Tag, SEP)
    txt_firstRow.Text = lsa_data(0)
    
    If lsa_data(1) <> "" And lsa_data(2) = "" Then
        ' search by DC
        Call cbo_DC_CARRIER_Code.SearchItem(lsa_data(1), "DC_Code")
    ElseIf lsa_data(1) = "" And lsa_data(2) <> "" Then
        'seach by CARRIER
        Call cbo_DC_CARRIER_Code.SearchItem(lsa_data(2), "CARRIER_Code")
    ElseIf lsa_data(1) <> "" And lsa_data(2) <> "" Then
        ' search by both
        Dim ll_i As Long
        For ll_i = 1 To cbo_DC_CARRIER_Code.Count
            If StrComp(CStr(cbo_DC_CARRIER_Code.GetItemData(cbo_DC_CARRIER_Code.ComboItems(ll_i).Key, "DC_Code")), lsa_data(1), vbTextCompare) = 0 And _
                StrComp(CStr(cbo_DC_CARRIER_Code.GetItemData(cbo_DC_CARRIER_Code.ComboItems(ll_i).Key, "CARRIER_Code")), lsa_data(2), vbTextCompare) = 0 Then
                Set cbo_DC_CARRIER_Code.SelectedItem = cbo_DC_CARRIER_Code.ComboItems(ll_i)
                Exit For
            End If
        Next
    End If
    If lsa_data(3) <> "" Then
        On Error GoTo fixBadFormat
        cal_validFrom.date_courte = Format(lsa_data(3), "dd\/mm\/yyyy")
        On Error GoTo errorHandler
    End If
    
    If lsa_data(4) <> "" Then
        On Error GoTo fixBadFormat
        cal_validTo.date_courte = Format(lsa_data(4), "dd\/mm\/yyyy")
        On Error GoTo errorHandler
    End If
    
    If lsa_data(5) <> "" Then
        txt_DropOff.Text = lsa_data(5)
    End If
    
    If lsa_data(6) <> "" Then
        Call SetComboItemValue(cbo_UOM_Code, lsa_data(6))
    End If
    
    If lsa_data(7) <> "" Then
        Call SetComboItemValue(cbo_currency, lsa_data(7))
    End If
    
    If lsa_data(8) <> "" Then
        Call SetComboItemValue(cbo_TT_Code, lsa_data(8))
    End If
    
    If lsa_data(9) <> "" Then
        Call SetComboItemValue(cbo_fullTruckCalc, lsa_data(9))
    End If
    Exit Sub
    
errorHandler:
    MsgBox ("Fatal error:" & Err.Description)
    Exit Sub
fixBadFormat:
    Call MsgBox("Error in date format, please check the starting/ending dates!", vbInformation)
    Resume Next
End Sub

Private Sub OKButton_Click()
    If Item_Check Then
        Call Item_Save
        Unload Me
    End If
End Sub

Private Sub Item_Save()
    Result = True
    
    FirstRow = txt_firstRow.Text
    XLSSheetName = lv_items.SelectedItem.Key
    
    DC_Code = cbo_DC_CARRIER_Code.GetItemData(cbo_DC_CARRIER_Code.SelectedItem.Key, "DC_Code")
    CARRIER_code = cbo_DC_CARRIER_Code.GetItemData(cbo_DC_CARRIER_Code.SelectedItem.Key, "CARRIER_Code")
    DC_CARRIER_Code = cbo_DC_CARRIER_Code.SelectedItem.Key
    UOM_Code = cbo_UOM_Code.SelectedItem.Key
    DropOffCost = Trim(txt_DropOff.Text)
    ValidityStart = cal_validFrom.date_dt
    ValidityEnd = cal_validTo.date_dt
    CURR_Code = cbo_currency.SelectedItem.Key
    TT_Code = cbo_TT_Code.SelectedItem.Key
    FullTruckCalculation = cbo_fullTruckCalc.SelectedItem.Key

End Sub

Private Function Item_Check() As Boolean
    Item_Check = False
    
    If lv_items.SelectedItem Is Nothing Then
        MsgBox ("Select item please.")
        Exit Function
    End If
    
    If cbo_DC_CARRIER_Code.SelectedItem Is Nothing Then
        MsgBox ("Select DC/Carrier please.")
        Exit Function
    End If
    
    If cbo_UOM_Code.SelectedItem Is Nothing Then
        MsgBox ("Select UOM please.")
        Exit Function
    End If

    If cbo_currency.SelectedItem Is Nothing Then
        MsgBox ("Select currency please.")
        Exit Function
    End If
    
    If Not isNumeric(txt_DropOff.Text) Then
        MsgBox ("Invalid value in Drop off cost.")
        Exit Function
    End If
    
    If cal_validFrom.date_dt = 0 Then
        MsgBox ("Invalid value in Validity start date.")
        Exit Function
    End If
    
    If cal_validTo.date_dt > 0 Then
        If cal_validFrom.date_dt > cal_validTo.date_dt Then
            MsgBox ("Invalid Validity start date is afer Validity end date.")
            Exit Function
        End If
    End If
    
    If cbo_TT_Code.SelectedItem Is Nothing Then
        MsgBox ("Invalid value in full VALID FOR.")
        Exit Function
    End If
    
    If cbo_fullTruckCalc.SelectedItem Is Nothing Then
        MsgBox ("Invalid value in full truck calculation.")
        Exit Function
    End If
    
    Item_Check = True
End Function

Private Function SetComboItemValue(ByRef ao_cbo As ArmCombobox, ByVal as_Key As String) As Boolean
On Error GoTo errorHandler
    SetComboItemValue = True
    If Not ao_cbo.SearchItem(as_Key) Then
        Call ao_cbo.Load
        SetComboItemValue = ao_cbo.SearchItem(as_Key)
    End If
    Exit Function
errorHandler:
    SetComboItemValue = False
End Function

Private Function SqlStr(ByVal as_Value As String, Optional ByVal al_MaxLen As Long = 8000, Optional ByVal ab_EmptyNULL As Boolean = False) As String
    If as_Value = "" And ab_EmptyNULL Then
        SqlStr = "NULL"
    Else
        SqlStr = "'" & Replace(Left(as_Value, IIf(Len(as_Value) <= al_MaxLen, Len(as_Value), al_MaxLen)), "'", "''") & "'"
    End If
End Function

